﻿Lasso = 
{
	URL: "ljax.lasso",
	VERSION: "0.0.1",
	REQUEST: undefined,
	APPNAME: "default",
	/*
	The data for a LJAX target is requested from within the client-side
	JavaScript by using the Lasso.includeTarget() function. This
	function accepts the following parameters:
	
	'targets' - The name or an array of names of the target(s) to retrieve.
	'options' - An object containing properties for the following:
		'args' - The argument string or an element such as a form, anchor or 
		other input element that will be used to create the argument string 
		which will be sent with the request
		
		'func' - If this optional function is provided, it will be called to
		handle the resulting data. This function will be passed the
		XMLHttpRequest object used for the request and the value of the 'param'
		parameter
		
		'param' - The parameter which is passed to the 'func' to handle the 
		resulting data. This is only utilized if 'func' is provided
		
		'afterFunc' - This optional function will be called, with the 
		XMLHttpRequest as it's only parameter after completing the include.
		
		'argsoverride' - Optional object containing the values that will be 
		substituted for the matching values found in the 'args' object. For 
		example, if argsoverride contained a property x with a value of y, and
		the args object was a form which contained an input field x, the value
		of y would be used regardless of the actual value of x in the form.
	*/
	includeTarget: function(targets, options)
	{
		var str = '';
		if (typeof(targets) == 'string')
		{
			str = '-target=' + escape(targets);
		}
		else
		{
			try
			{
				for (var i = 0; i < targets.length; ++i)
				{
					if (i != 0)
						str += '&';
					str += '-target=' + escape(targets[i]);
				}
			}
			catch(e){ alert(e); }
		}
		if (options && options.args != undefined)
		{
			if (typeof(options.args) == 'string')
			{
				str += '&' + options.args;
			}
			else
			{
				try
				{
					var res = this.encodeValuesFor(options.args, options.argsoverride);
					if (res && res.length)
						str += '&' + res;
				}catch(e){}
			}
		}
		return this.fetchRequest(undefined, str, (options && options.func != undefined) ? options.func :
			function(req, param) 
			{ 				
				var xml = undefined;
				if (req.responseXML)
				{
					var elem = req.responseXML.getElementsByTagName('ljax');
					if (elem && elem.length > 0)
						xml = elem[0];
				}
				if (xml == undefined || xml.nodeName != 'ljax')
				{	
					if (req.responseText && req.responseText.length > 0)
						document.write(req.responseText);
					return;
				}
				for (var idx = 0; idx < xml.childNodes.length; ++idx)
				{
					var thisXml = xml.childNodes[idx];

					// skip text nodes
					if (thisXml.nodeType == 3) continue;

					var id = thisXml.getAttribute('id');
					if (thisXml && thisXml.nodeType == 1 && id)
					{
						var repNode = document.getElementById(id);
						if (repNode)
						{
							var src = '';
							if (thisXml.innerHTML)
							{
								src = thisXml.innerHTML;
							}
							else if (thisXml.xml)
							{
								for (var innerIdx = 0; innerIdx < thisXml.childNodes.length; ++innerIdx)
								{
									src += thisXml.childNodes[innerIdx].xml;
								}
							}
							else if (document.importNode)
							{
								thisXml = document.importNode(thisXml, true);
								src = thisXml.innerHTML;							
							}
							repNode.innerHTML = src;
						}
					}		
				}
			}, options? options.param : undefined, options? options.afterFunc : undefined);
	},	
	onreadystatechange: function() // some implementations (Safari) send an Event as a param here
	{
		if (Lasso.REQUEST.readyState == 4)
		{
			if (Lasso.ljaxCallback != undefined)
			{
				Lasso.ljaxCallback(Lasso.REQUEST, Lasso.ljaxCallbackSecondParam);
				if (Lasso.ljaxCallbackPostFunc != undefined)
				{
					Lasso.ljaxCallbackPostFunc(Lasso.REQUEST);
					Lasso.ljaxCallbackPostFunc = undefined;
				}
				Lasso.ljaxCallback = undefined;
				Lasso.ljaxCallbackSecondParam = undefined;
				Lasso.REQUEST.abort(); // have to call abort here or IE won't let you reuse the request
			}
		}
		else
		{
		
		}
	},
	fetchRequest: function(url, value, callback, callbackSecondParam, postFunc)
	{
		if (this.REQUEST == undefined)
		{
			if (window.XMLHttpRequest) 
			{
				this.REQUEST = new XMLHttpRequest();
			}
			else if (window.ActiveXObject)
			{
				this.REQUEST = new ActiveXObject("Microsoft.XMLHTTP");
			}
		}
		if (url == undefined)
		{
			url = this.URL;
		}
		if (this.REQUEST)
		{
			this.ljaxCallback = callback;
			this.ljaxCallbackSecondParam = callbackSecondParam;
			this.ljaxCallbackPostFunc = postFunc;
			this.REQUEST.onreadystatechange = this.onreadystatechange;
			this.REQUEST.open("POST", url, true);
			this.REQUEST.setRequestHeader('X-JLAX-VERSION', this.VERSION);
			this.REQUEST.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
			this.REQUEST.send(value);
			return true;
		}
		return false;
	},
	encodeValuesFor: function(input, override)
	{
		if (override == undefined)
			override = {};
		var str = '';
		var nodeName = input.nodeName.toLowerCase();
		if (nodeName == 'form')
		{
			for (var i = 0; i < input.elements.length; ++i)
			{
				if (i != 0)
					str += '&';
				str += this.encodeValuesFor(input.elements[i], override);
			}
		}
		else if (nodeName == 'input' || nodeName == 'textarea')
		{
			str += escape(input.name) + '=' + escape(override[input.name] != undefined? override[input.name] : input.value);
		}
		else if (nodeName == 'a')
		{
			var idx = input.href.indexOf('?');
			if (idx != -1)
				str += input.href.substring(idx+1);
			// no input == else nothing to send
		}
		else if (nodeName == 'select')
		{
			if (override[input.name])
			{
				str += escape(input.name) + '=' + escape(override[input.name]);
			}
			else
			{
				var didOne = false;
				for (var i = 0; i < input.options.length; ++i)
				{
					if (input.options[i].selected)
					{
						if (didOne)
							str += '&';
						didOne = true;
						str += input.name + '=' + input.options[i].value;
					}
				}
			}
		}	
		return str;
	}
}